require 'rspec'
require 'watir-scroll'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/varUtility/landing'
require_relative '../../helper/modal'
require_relative '../../common/accessVarUtility'
require_relative '../../common/common'
require_relative '../../pages/varUtility/manage_settings'
require_relative '../../module/DateUtility'
require_relative '../../helper/table'
require_relative '../../pages/varUtility/error_validation'
require_relative '../../pages/varUtility/manage_settings/request_settings'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/vaToolSet/home'
require_relative '../../pages/landing_page'

require 'vaToolSet/vaToolSet_pageObject'
require_relative '../../common/accessVarUtility'

describe '[Story VARUT-82|Story VARUT-223 : Utility - Requests - View/Edit Service Settings ]
          [Story VARUT-217: Utility - Display Stop Codes]
          [Story VARUT-528: VAR Utility - Allow users to configure request limit]
          [Story VARUT-438: VAR Utility - Access Request Feature]' do
  include DriverUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @db = connectToVarMongoDB("var-utility")
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @base = Base.new(@driver)
    @request_setting = Request_Settings.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)
    @table = Table.new(@driver)
    @error = Error_Validation.new(@driver)
    @modal = Modal.new(@driver)
    @loginUtil = AccessVarUtility.new(@driver)
    @home = Home.new(@driver)

    @landing_page = LandingPage.new(@driver)
    @vts_po  = VaToolSet_PageObject.new(@driver)
    #Reset Data in Mongo DB
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    removeCollection("requestEligibilityCriteria", @db)

    updateDocument("clinical-services", "323", "submittedRequestLimit", 1, @db)
    updateDocument("clinical-services", "203", "submittedRequestLimit", 2, @db)
    updateDocument("clinical-services", "408", "submittedRequestLimit", 2, @db)
    updateDocument("clinical-services", "502", "submittedRequestLimit", 2, @db)

  end

  after(:all) do
    @driver.close
  end


  context '[AC#VARUT-356|TC#VARUT-357:]
           [AC#VARUT-358|TC#VARUT-359 - Validate requests settings]
           [AC#VARUT-707|TC#VARUT-708: Test - Validate display of Stop codes for each Type of Care]
           [AC#VARUT-187|TC#VARUT-186: Test - View/Edit Service Patient History Limit
           [AC#VARUT-1095|TC#VARUT-1096: Verify Allow users to configure request limit]
           [AC#VARUT-1226|TC#VARUT-714: Validate existing Request table feature and table title]' do
    it "Login" do
      @loginUtil.access_var_utility(UserAccess7)
      @landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.rightFooter == "Logged in as PROVIDER, SEVEN"}
      expect(@landing.rightFooter).to eq("Logged in as PROVIDER, SEVEN")
    end

    it "Request Page" do
      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings

      @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
      @vts_po.landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@vts_po.landing.primary_header).to eq("Welcome")

      @manage_setting.clickOption("Requests")
      expect(@landing.primary_header).to eq("Requests")

      Watir::Wait.until {@table.tableList_elements.length > 1}

      expect(@request_setting.request_settings_heading).to eq("BOSTON HCS VAMC Request Settings")
      expect(@request_setting.instructional_text).to eq("For the care types in the groupings listed below, provide the request settings supported by this location.")
      expect(@request_setting.required_field_label).to eq("* required field")
      expect(@request_setting.type_of_care_table_title).to eq("Clinic Profile Based Types of Care")


      expect(@table.getNthTableHeader(0)).to eq("Type of Care\n(Primary/Secondary Stop Code)")
      expect(@table.getNthTableHeader(1)).to eq("Supported at this Facility?")
      expect(@table.getNthTableHeader(2)).to eq("* Last seen within (Months)")
      expect(@table.getNthTableHeader(3)).to eq("* Submitted Request Limit")

      #Column1 data
      expect(@table.getTextForRowCol(1,1)).to eq("Primary Care\n(Primary/Secondary Stop Code)\n(322, 323, 350)")
      expect(@table.getTextForRowCol(2,1)).to eq("Audiology\n(Primary/Secondary Stop Code)\n(203)")
      expect(@table.getTextForRowCol(3,1)).to eq("Optometry\n(Primary/Secondary Stop Code)\n(408)")
      expect(@table.getTextForRowCol(4,1)).to eq("Outpatient Mental Health\n(Primary/Secondary Stop Code)\n(502/125, 502/185, 502/186, 502/187, 502/509, 502/510)")

      #Column2 data
      expect(@request_setting.primaryCare_options).to eq(["No", "Yes - Any Veteran"])
      expect(@request_setting.audiology_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])
      expect(@request_setting.optometry_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])
      expect(@request_setting.outpatientMentalHealth_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])

    end

    it "Validate Type of Care = Primary Care" do
      #Type of Care = Primary Care
      @request_setting.primaryCare = "No"
      expect(@request_setting.primarycareOptionLastSeen_element.visible?).to eq(false)
      expect(@request_setting.primaryCareRequestLimit_element.visible?).to eq(false)

      @request_setting.primaryCare = "Yes - Any Veteran"
      expect(@request_setting.primarycareOptionLastSeen_element.visible?).to eq(false)
      expect(@request_setting.primaryCareRequestLimit_element.visible?).to eq(true)

    end


    it "Validate Type of Care = Audiology" do
      #Type of Care = Audiology
      @request_setting.audiology = "No"
      expect(@request_setting.audiologyLastSeen_element.visible?).to eq(false)
      expect(@request_setting.audiologyRequestLimit_element.visible?).to eq(false)


      @request_setting.audiology = "Yes - Any Veteran"
      expect(@request_setting.audiologyLastSeen_element.visible?).to eq(false)
      expect(@request_setting.audiologyRequestLimit_element.visible?).to eq(true)

    end

    it "Validate Type of Care = Optometry" do
      #Type of Care = Optometry
      @request_setting.optometry = "No"
      expect(@request_setting.optometryLastSeen_element.visible?).to eq(false)
      expect(@request_setting.optometryRequestLimit_element.visible?).to eq(false)

      @request_setting.optometry = "Yes - Any Veteran"
      expect(@request_setting.optometryLastSeen_element.visible?).to eq(false)
      expect(@request_setting.optometryRequestLimit_element.visible?).to eq(true)

    end

    it "Validate Type of Care = Outpatient Mental Health" do
      #Type of Care = Outpatient Mental Health
      @request_setting.outpatientMentalHealth = "No"
      expect(@request_setting.outpatientMentalHealthLastSeen_element.visible?).to eq(false)
      expect(@request_setting.outpatientMentalHealthRequestLimit_element.visible?).to eq(false)

      @request_setting.outpatientMentalHealth = "Yes - Any Veteran"
      expect(@request_setting.outpatientMentalHealthLastSeen_element.visible?).to eq(false)
      expect(@request_setting.outpatientMentalHealthRequestLimit_element.visible?).to eq(true)

    end

    it "Submitted Request Limit" do

      #Default value
      expect(@request_setting.primaryCareRequestLimit_options).to eq(["Select", "1"])
      expect(@request_setting.primaryCareRequestLimit).to eq("1")

      expect(@request_setting.audiologyRequestLimit_options).to eq(["Select","1", "2"])
      expect(@request_setting.audiologyRequestLimit).to eq("2")

      expect(@request_setting.optometryRequestLimit_options).to eq(["Select","1", "2"])
      expect(@request_setting.optometryRequestLimit).to eq("2")

      expect(@request_setting.outpatientMentalHealthRequestLimit_options).to eq(["Select","1", "2"])
      expect(@request_setting.outpatientMentalHealthRequestLimit).to eq("2")

      updateDocument("clinical-services", "323", "submittedRequestLimit", 5, @db)
      updateDocument("clinical-services", "203", "submittedRequestLimit", 5, @db)
      updateDocument("clinical-services", "408", "submittedRequestLimit", 4, @db)
      updateDocument("clinical-services", "502", "submittedRequestLimit", 1, @db)

      #Select Continue in the confirmation modal
      @base.home_btn

      @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
      #todo: need to remove Popup modal text
      expect(@modal.modalTitle).to eq("Popup modal\nConfirmation")

      expect(@modal.buttons_elements[1].text).to eq("Continue")
      @modal.buttons_elements[1].click

      @common.waitWhileSpinnerPresent

      #select VAR Utility open
      button_element = @driver.button( :id=>'open-var-utility-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)

      @common.waitWhileSpinnerPresent

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings

      @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
      @vts_po.landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@vts_po.landing.primary_header).to eq("Welcome")

      @manage_setting.manage_settings_options_elements[1].when_present(TIME_OUT_LIMIT)
      @manage_setting.clickOption('Requests')
      @request_setting.primaryCare_element.when_present(TIME_OUT_LIMIT)

      #When Supported at this Facility? = No
      expect(@request_setting.primaryCareRequestLimit_element.visible?).to eq(false)
      expect(@request_setting.audiologyRequestLimit_element.visible?).to eq(false)
      expect(@request_setting.optometryRequestLimit_element.visible?).to eq(false)
      expect(@request_setting.outpatientMentalHealthRequestLimit_element.visible?).to eq(false)

      @request_setting.primaryCare = "Yes - Any Veteran"
      @request_setting.audiology = "Yes - Any Veteran"
      @request_setting.optometry = "Yes - Any Veteran"
      @request_setting.outpatientMentalHealth = "Yes - Any Veteran"

      @request_setting.primaryCareRequestLimit_element.when_present(TIME_OUT_LIMIT)
      expect(@request_setting.primaryCareRequestLimit_options).to eq(["Select", "1", "2", "3", "4", "5"])
      @request_setting.primaryCareRequestLimit = 3

      expect(@request_setting.audiologyRequestLimit_options).to eq(["Select", "1", "2", "3", "4", "5"])
      @request_setting.audiologyRequestLimit = 2

      expect(@request_setting.optometryRequestLimit_options).to eq(["Select", "1", "2", "3", "4"])
      @request_setting.optometryRequestLimit = 1

      expect(@request_setting.outpatientMentalHealthRequestLimit_options).to eq(["Select", "1"])
      @request_setting.outpatientMentalHealthRequestLimit = "Select"

      @request_setting.bottomSave

      @error.errorSummaryHeader_element.when_visible(TIME_OUT_LIMIT)
      expect(@error.isErrorMsgDisplayed?("Submitted Request Limit Outpatient Mental Health field is required")).to eq(true)

      @request_setting.outpatientMentalHealthRequestLimit = 1

    end

    it "Validate Confirmation Modal on Save" do
      #Primary Care
      @request_setting.primaryCare = "Yes - Any Veteran"

      #Audiology
      @request_setting.audiology = "Yes - Based Upon Time Frame"
      expect(@request_setting.audiologyLastSeen_element.exists?).to eq(true)
      expect(@request_setting.audiologyLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

      #Select Duration and Save.
      @request_setting.audiologyLastSeen = "24 months (730 days)"

      #Optometry
      @request_setting.optometry = "Yes - Based Upon Time Frame"
      expect(@request_setting.optometryLastSeen_element.exists?).to eq(true)
      expect(@request_setting.optometryLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

      #Select Duration and Save.
      @request_setting.optometryLastSeen = "12 months (365 days)"

      #Outpatient Mental Health
      @request_setting.outpatientMentalHealth = "Yes - Based Upon Time Frame"
      expect(@request_setting.outpatientMentalHealthLastSeen_element.exists?).to eq(true)
      expect(@request_setting.outpatientMentalHealthLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

      #Select Duration and Save.
      @request_setting.outpatientMentalHealthLastSeen = "24 months (730 days)"

      @request_setting.bottomSave

      #Validate Confirmation Modal
      @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)

      #todo: need to remove Popup modal text when defect is fixed
      expect(@modal.modalTitle).to eq("Popup modal\nConfirmation")
      expect(@modal.content).to eq("The Request settings have been saved.")

      @modal.ok

      Watir::Wait.until {@table.tableList_elements.length > 1}

      #Validate that the selections are saved.
      expect(@request_setting.audiology).to eq("Yes - Based Upon Time Frame")
      expect(@request_setting.audiologyLastSeen).to eq("24 months (730 days)")
      expect(@request_setting.optometry).to eq("Yes - Based Upon Time Frame")
      expect(@request_setting.optometryLastSeen).to eq("12 months (365 days)")
      expect(@request_setting.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
      expect(@request_setting.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

      expect(@request_setting.primaryCareRequestLimit).to eq("3")
      expect(@request_setting.audiologyRequestLimit).to eq("2")
      expect(@request_setting.optometryRequestLimit).to eq("1")
      expect(@request_setting.outpatientMentalHealthRequestLimit).to eq("1")

    end

    it "Retrieve mongo" do

      value = getRequestSettingsByTypeOfCare("requestEligibilityCriteria", "523", PRIMARY_CARE, @db)
      expect("No").to eq(value['patientHistoryRequired'].to_s)
      expect(PRIMARY_CARE).to eq(value['typeOfCare'].to_s)
      expect(3).to eq(value['submittedRequestLimit'])

      value = getRequestSettingsByTypeOfCare("requestEligibilityCriteria", "523", AUDIOLOGY, @db)
      expect("Yes").to eq(value['patientHistoryRequired'].to_s)
      expect(AUDIOLOGY).to eq(value['typeOfCare'].to_s)
      expect("730").to eq(value['patientHistoryDuration'].to_s)
      expect(2).to eq(value['submittedRequestLimit'])

      value = getRequestSettingsByTypeOfCare("requestEligibilityCriteria", "523", OPTOMETRY, @db)
      expect("Yes").to eq(value['patientHistoryRequired'].to_s)
      expect(OPTOMETRY).to eq(value['typeOfCare'].to_s)
      expect("365").to eq(value['patientHistoryDuration'].to_s)
      expect(1).to eq(value['submittedRequestLimit'])

      value = getRequestSettingsByTypeOfCare("requestEligibilityCriteria", "523", MENTAL_HEALTH, @db)
      expect("Yes").to eq(value['patientHistoryRequired'].to_s)
      expect(MENTAL_HEALTH).to eq(value['typeOfCare'].to_s)
      expect("730").to eq(value['patientHistoryDuration'].to_s)
      expect(1).to eq(value['submittedRequestLimit'])

    end

    it "Error validation" do
      #Last Seen in Months is a required field
      #Click Save without selecting a value for last seen for Audiology Optometry and Outpatient Mental health

      @request_setting.audiologyLastSeen = "Select"
      @request_setting.optometryLastSeen = "Select"
      @request_setting.outpatientMentalHealthLastSeen = "Select"
      @request_setting.topSave

      @error.errorSummaryHeader_element.when_visible(TIME_OUT_LIMIT)

      expect(@error.isErrorMsgDisplayed?("Last Seen Within (Months) " + AUDIOLOGY + " field is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Last Seen Within (Months) " + OPTOMETRY + " field is required")).to eq(true)
      expect(@error.isErrorMsgDisplayed?("Last Seen Within (Months) " + MENTAL_HEALTH + " field is required")).to eq(true)

      @request_setting.typeOfCareReset

      Watir::Wait.until {@table.tableList_elements.length > 1}

      expect(@error.errorSummaryHeader_element.exist?).to eq(false)

    end

    it "Logout and Log back in as different user for same location to verify the last saved data is displayed" do
      @loginUtil.logout_login_ends_on_var_utility(UserAccess50)
      @landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings

      @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
      @vts_po.landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)

      sleep 10

      @manage_setting.clickOption('Requests')
      expect(@landing.primary_header).to eq("Requests")

      Watir::Wait.until {@table.tableList_elements.length > 1}

      #Validate the selections
      expect(@request_setting.audiology).to eq("Yes - Based Upon Time Frame")
      expect(@request_setting.audiologyLastSeen).to eq("24 months (730 days)")
      expect(@request_setting.optometry).to eq("Yes - Based Upon Time Frame")
      expect(@request_setting.optometryLastSeen).to eq("12 months (365 days)")
      expect(@request_setting.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
      expect(@request_setting.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

      expect(@request_setting.primaryCareRequestLimit).to eq("3")
      expect(@request_setting.audiologyRequestLimit).to eq("2")
      expect(@request_setting.optometryRequestLimit).to eq("1")
      expect(@request_setting.outpatientMentalHealthRequestLimit).to eq("1")

    end

    context 'AC#VARUT-211|TC#VARUT-212: Utility - Navigate without Save Confirmation Modal Validate' do
      it "Navigate without save and validate changes are not saved" do
        #Select different values for each field other than what is being saved.
        @request_setting.primaryCare = "Yes - Any Veteran"
        @request_setting.audiology = "Yes - Any Veteran"
        @request_setting.optometry = "Yes - Any Veteran"
        @request_setting.outpatientMentalHealth = "Yes - Any Veteran"

        #Click the home icon and validate the confirmation modal

        @base.home_btn

        @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)

        expect(@modal.modalTitle).to eq("Popup modal\nConfirmation")
        expect(@modal.content).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
        @modal.return

        Watir::Wait.until {@table.tableList_elements.length > 1}
        @common.waitWhileSpinnerPresent

        #Validate the last selected values
        expect(@request_setting.audiology).to eq("Yes - Any Veteran")
        expect(@request_setting.audiologyLastSeen_element.exists?).to eq(false)
        expect(@request_setting.optometry).to eq("Yes - Any Veteran")
        expect(@request_setting.optometryLastSeen_element.exists?).to eq(false)
        expect(@request_setting.outpatientMentalHealth).to eq("Yes - Any Veteran")
        expect(@request_setting.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

        @request_setting.outpatientMentalHealth = "No"

        #Select Continue in the confirmation modal
        @request_setting.home_btn

        @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
        expect(@modal.modalTitle).to eq("Popup modal\nConfirmation")

        expect(@modal.buttons_elements[1].text).to eq("Continue")
        @modal.buttons_elements[1].click

        @home.varUtilOpen_element.when_visible(TIME_OUT_LIMIT)

        #select VAR Utility open
        button_element = @driver.button( :id=>'open-var-utility-btn')
        @driver.execute_script("$(arguments[0]).click();",button_element)

        @common.waitWhileSpinnerPresent

        @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
        @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
        @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
        @landing_page.view_settings

        @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
        @vts_po.landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)
        expect(@vts_po.landing.primary_header).to eq("Welcome")

        @manage_setting.clickOption('Requests')

        Watir::Wait.until {@table.tableList_elements.length > 1}

        expect(@request_setting.audiology).to eq("Yes - Based Upon Time Frame")
        expect(@request_setting.audiologyLastSeen).to eq("24 months (730 days)")
        expect(@request_setting.optometry).to eq("Yes - Based Upon Time Frame")
        expect(@request_setting.optometryLastSeen).to eq("12 months (365 days)")
        expect(@request_setting.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
        expect(@request_setting.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

      end
    end

  end
end






